import { Platform, View, FlatList, TouchableOpacity, Dimensions } from 'react-native';
import React, { useState, useEffect } from 'react';
import LeftIcon from '../../../../../assets/svgs/product details/leftIcon.svg';
import RightIcon from '../../../../../assets/svgs/product details/rightIcon.svg';
import dpr from '../../../../Utilities/CustomStyleAttribute/dpr';
import { itemCarouselStyle } from './ItemCarouselStyle';
import SingleImage from './SingleImage';
import CustomSVG from '../../../../../src/components/CustomSVG/CustomSVG';

const { width } = Dimensions.get('screen');

const moveHeight = dpr(15);
const moveWidth = dpr(10);

let scrollValue = 0;
let scrolled = 0;
let flatList;
const ItemCarousel = ({ data, productBadge }) => {
    const { images, activeImage } = data || {};
    const [currentSlideIndex, setCurrentSlideIndex] = useState(activeImage);

    useEffect(() => {
        scrollValue = dpr('wf') * currentSlideIndex;
        flatList?.scrollToOffset({
            animated: true,
            offset: scrollValue,
        });
    }, [currentSlideIndex]);

    useEffect(() => {
        setCurrentSlideIndex(activeImage);
        scrollValue = dpr('wf') * activeImage;
        scrolled = activeImage;
        flatList?.scrollToOffset({
            animated: true,
            offset: scrollValue,
        });
    }, [activeImage]);

    const moveBack = () => {
        if (scrolled === 0) {
            return;
        } else {
            scrolled--;
            setCurrentSlideIndex(scrolled);
            Platform.OS === "android" && (scrollValue = scrollValue - dpr('wf'));
        }
        flatList?.scrollToOffset({
            animated: true,
            offset: scrollValue,
        });
    };
    const moveNext = () => {
        if (scrolled === images?.length - 1) {
            return;
        } else {
            scrolled++;
            setCurrentSlideIndex(scrolled);
            Platform.OS === "android" && (
                scrolled < images?.length && (scrollValue = scrollValue + dpr('wf'))
            );
            flatList?.scrollToOffset({
                animated: true,
                offset: scrollValue,
            });
        }
    };
    const updateCurrentSlideIndex = (e) => {
        const contentOffsetX = e.nativeEvent.contentOffset.x;
        scrollValue = contentOffsetX;
        const currentIndex = Math.round(scrollValue / width);
        scrolled = currentIndex;
        setCurrentSlideIndex(currentIndex);
    };
    return (
        <View>
            <TouchableOpacity
                style={itemCarouselStyle.leftIcon}
                onPress={moveBack}
                disabled={currentSlideIndex === 0 ? true : false}
            >
                <CustomSVG svgIcon={LeftIcon} isRtl={1}
                    height={moveHeight}
                    width={moveWidth}
                    fill={currentSlideIndex === 0 ? '#DFDFDF' : '#898989'}
                />
            </TouchableOpacity>
            <TouchableOpacity
                style={itemCarouselStyle.rightIcon}
                onPress={moveNext}
                disabled={
                    currentSlideIndex === images?.length - 1 ? true : false
                }
            >
                <CustomSVG svgIcon={RightIcon} isRtl={1}
                    height={moveHeight}
                    width={moveWidth}
                    fill={
                        currentSlideIndex === images?.length - 1
                            ? '#DFDFDF'
                            : '#898989'
                    }
                />
            </TouchableOpacity>
            <FlatList
                ref={(flat) => {
                    flatList = flat;
                }}
                data={images}
                keyExtractor={(_, index) => 'key' + index}
                listKey={(_, i) => `list-a${i}`}
                renderItem={({ item, index }) => (
                    <SingleImage
                        item={item}
                        index={index}
                        data={images}
                        setCurrentSlideIndex={setCurrentSlideIndex}
                        productBadge={productBadge}
                    />
                )}
                horizontal
                pagingEnabled
                scrollEnabled={true}
                snapToAlignment='center'
                scrollEventThrottle={16}
                decelerationRate={'fast'}
                showsHorizontalScrollIndicator={false}
                onMomentumScrollEnd={updateCurrentSlideIndex}
                overScrollMode='never'
            />
            <View style={itemCarouselStyle.indidatorCont}>
                {images.map((_, index) => (
                    <View
                        key={`key${index}`}
                        style={[
                            itemCarouselStyle.indicator,
                            currentSlideIndex === index && itemCarouselStyle.activeIndicator,
                        ]}
                    />
                ))}
            </View>
        </View>
    );
};

export default ItemCarousel;
